# -*- coding: utf-8 -*-
"""
Created on Tue May 21 14:40:29 2019

@author: adijkstra
"""
"""
NOTE!!!! THIS CODE ONLY WORKS WHEN YOUR X-AXIS DATA IS EQUALLY SPACED
"""

import numpy as np
from numpy import exp, linspace, random
import pandas as pd
import matplotlib.pyplot as plt
import os
from scipy.optimize import curve_fit
from scipy.special import gamma
from scipy import signal
from scipy.ndimage import convolve1d
from scipy.ndimage import correlate1d
from scipy.optimize import fsolve

#============Get the current directory
path = os.getcwd()
print("The current directory is: %s" % path )
#==================================================================



#specify from which file the data comes
fileNameTemp ='H06138_LICorrIntensityTemperatures.txt'
importedFileTemp=np.array(pd.read_csv(fileNameTemp, sep='\t', header=None))

#select the data desired
#Energy scale
energyData = importedFileTemp[7:,1]
energyData = energyData.astype(np.float)  #turn into a float data format
#Intensity measured at lowT
Intensity4K = np.array(importedFileTemp[7:,32])
Intensity4K = Intensity4K.astype(np.float)
Normalized4K =np.divide(Intensity4K,np.amax(Intensity4K))
#Intensity at high T
Intensity280K = np.array(importedFileTemp[7:,2])
Intensity280K = Intensity280K.astype(np.float)
Normalized280K =np.divide(Intensity280K,np.amax(Intensity280K))
"""

#Plot the normalized graphs to show what I am working with
plt.plot(energyData, Normalized4K, 'r^')
plt.plot(energyData, Normalized280K, 'b^')
plt.axis([0.2, 0.55, 0,1.2])
plt.show()

"""

"""
=======================================================================
===============Define all the used physical constants==================
=======================================================================
"""
c = 2.9979e10 #cm/s
mRestElectron= 0.511e6 #eV
mEffC1 = np.power(np.multiply(np.multiply(0.076,0.997),0.076),np.divide(1,3))
mEffC2 = np.power(np.multiply(np.multiply(0.038,0.33),0.038),np.divide(1,3))
mLH = np.power(np.multiply(np.multiply(0.079,0.085),0.079),np.divide(1,3))
mHH = np.power(np.multiply(np.multiply(0.055,0.463),0.055),np.divide(1,3))
mEffV1 = mLH+mHH
mEffV2 = np.power(np.multiply(np.multiply(0.252,0.044),0.252),np.divide(1,3))
hBar = 6.582119569e-16 #eV*s
kb = 8.617333e-5 #eV/K





"""
==============================================================
===============Define all the used functions==================
==============================================================
"""

def gaussian(x, amp, cen, wid):
    return amp * exp(-(x-cen)**2 / wid)

def simpleDOS(E, Eg, A, normalized=True):
    if np.isscalar(E) == False:
        DOS=np.zeros(int(np.size(E)))
        n=0
        for i in E:
            if i<=Eg:
                DOS[n]=0.0
            else:
                DOS[n]=np.multiply(A,np.sqrt(i-Eg))              
            n+=1
        return DOS     

    else:
        if E<=Eg:
            return 0.0
        else:
            return np.multiply(A,np.sqrt(E-Eg))
    
def fermiDirac(E,Ef,T,broadeningFactor=1.0):
    #THis function is shaped such to avoid an overflow in the exponent
    margin=100*kb*T*broadeningFactor
    funcfD = lambda E: np.divide(1,(1+np.exp(np.divide((E-Ef)*broadeningFactor,(kb*T)))))
    if np.isscalar(E) == False:
        fd=np.zeros(int(np.size(E)))
        n=0
        for i in E:
            if i<Ef-margin:
                fd[n]=1
            elif i>=Ef-margin and i<=Ef+margin:
                fd[n]=funcfD(i)
            elif i>Ef+margin:
                fd[n]=0
            else:
                fd[n]=0
                break
            n+=1
        return fd    

    else:
        if E<Ef-margin:
            return 1
        if E>=Ef-margin and E<=Ef+margin:
            return funcfD(E)
        if E>Ef+margin:
            return 0
        else:
            return 0
            print("A problem occurred in the fermiDirac function")

def urbachTail(E, Eg, gam, theta=1, normalized=False):
    if gam==0:
        print("urbachTail: gamma cannot be zero!")
    N=np.divide(1,(2*gam*gamma(1+np.divide(1,theta)))) #This normalization factor makes that the area under neath the graph remains to be 1
    if normalized == False:
        return np.multiply(np.exp(-np.power(np.absolute((np.divide((E-Eg),gam))),theta)),N)
    elif normalized == True:
        return np.divide(np.multiply(np.exp(-np.power(np.absolute((np.divide((E-Eg),gam))),theta)),N), np.amax(np.multiply(np.exp(-np.power(np.absolute((np.divide((E-Eg),gam))),theta)),N)))
        
def tailedDOS(E, Eg, A, gam, theta=1, normalized=False):
    #First check it gamma is zero, if so then there is no tail and simple DOS applies
    if gam==0:
        return simpleDOS(E, Eg, A, normalized)
    #First make an array that will be used to define the urbach tail, important is that I know the length of the array and that the peak is at te exact center
    EStepsize=np.divide((E[40]-E[0]),40) #Get the energy stepsize
    HalfLength = int(1000) #Choose a value for the length of the array used for the peak function 
    EDataUT = np.zeros(HalfLength*2) #define the array that will be used and fill the array with energy values with zero at the center of the array.
    for i in range (HalfLength):
        EDataUT[i]=(i-HalfLength+0.5)*EStepsize
        EDataUT[i+HalfLength]=(i+0.5)*EStepsize
    #Now the FULL convolution can be done between the urbach tail and the simple DOS    
    tailDOS=np.convolve(urbachTail(EDataUT, 0, gam, theta), simpleDOS(E, Eg, A), 'full')/sum(urbachTail(EDataUT, 0, gam, theta))
    #The convolution is now exactly shifted by half of the urbach tail length minus one cell So now I correct for this and we can return the array.
    tailDOS=tailDOS[HalfLength-1:]
    tailDOS=tailDOS[0:int(np.size(E))]
    #Then return the signal
    if normalized == False:
        return tailDOS
    elif normalized == True:
        return np.divide(tailDOS,np.amax(tailDOS))
    
def simpleDOS_FD(E, Eg, A, T, Eshift=0, normalized=False):
    if normalized == False:
        return np.multiply(simpleDOS(E,Eg,A),fermiDirac(E,Eg,T, Eshift))
    elif normalized == True:
        return np.divide(np.multiply(simpleDOS(E,Eg,A),fermiDirac(E,Eg,T, Eshift)),np.amax(np.multiply(simpleDOS(E,Eg,A),fermiDirac(E,Eg,T, Eshift))))

def tailedDOS_FD(E, Eg, A, T, gam, theta=1, Eshift=0.0, normalized=False):
    if normalized == False:
        return np.multiply(tailedDOS(E, Eg, A, gam, theta),fermiDirac(E,Eg,T,Eshift))
    elif normalized == True:
        return np.divide(np.multiply(tailedDOS(E, Eg, A, gam, theta),fermiDirac(E,Eg,T,Eshift)),np.amax(np.multiply(tailedDOS(E, Eg, A, gam, theta),fermiDirac(E,Eg,T,Eshift))))

def tailedAbsorptivity (E, Eg, A, gam, theta=1, Eshift=0, d=1, normalized=False):
    #d is a characeristic length scale of absorption
    if normalized == False:
        return 1-np.exp(-tailedDOS(E, Eg, A, gam, theta)*d)
    elif normalized == True:
        return np.divide((1-np.exp(-tailedDOS(E, Eg, A, gam, theta)*d)),np.amax(1-np.exp(-tailedDOS(E, Eg, A, gam, theta)*d)))
    
def simpleAbsorptivity (E, Eg, A, Eshift=0, d=1, normalized=False):
    #d is a characeristic length scale of absorption in paper used as fitting parameter
    if normalized == False:
        return 1-np.exp(-simpleDOS(E, Eg, A)*d)
    elif normalized == True:
        return np.divide((1-np.exp(-simpleDOS(E, Eg, A)*d)),np.amax(1-np.exp(-simpleDOS(E, Eg, A)*d)))
    
def tailedAbsortivityOccCorr(E, Eg, A, T, gam, Dmu, d=1, theta=1, Eshift=0, normalized=False):
    #d is a characeristic length scale of absorption in paper used as fitting parameter
    temp=np.multiply(tailedDOS(E, Eg, A, gam, theta),(1-np.divide(2,np.exp(np.divide((E-Dmu),(2*np.multiply(kb,T))))+1)))
    temp=1-np.exp(-temp*d)
    #temp=(1-np.divide(2,np.exp(np.divide((E-Dmu),(2*np.multiply(k,T))))+1))
    if normalized == False:
        return temp
    elif normalized == True:
        return np.divide(temp,temp[-1])
    
def tailedAbsortivityOccCorrAsym(E, Eg, A, T, gam, Efe, Efh, d=1, theta=1, Eshift=0, normalized=False):
    #d is a characeristic length scale of absorption in paper used as fitting parameter
    Dmu=Efe-Efh
    if Efh<0:       
        Pn=1+np.divide(Efh,(Dmu-Eg))
        Pp=1-Pn
    else:
        Pn=1
        Pp=0
    #Pn=0.5
    #Pp=0.5
    #temp=np.multiply(tailedDOS(E, Eg, A, gam, theta),(1-np.divide(1,np.exp(np.divide(Pn*(E-Dmu),(np.multiply(kb,T))))+1)-np.divide(1,np.exp(np.divide(Pp*(E-Dmu),(np.multiply(kb,T))))+1)))
    temp=np.multiply(tailedDOS(E, Eg, A, gam, theta),(1-fermiDirac(E,Dmu,T,Pn)-fermiDirac(E,Dmu,T,Pp)))
    temp=1-np.exp(-temp*d)
    #temp=(1-np.divide(2,np.exp(np.divide((E-Dmu),(2*np.multiply(k,T))))+1))
    if normalized == False:
        return temp
    elif normalized == True:
        return np.divide(temp,temp[-1])
     
def LSW_tailedAbs_PL (E, Eg, A, T, gam, Dmu, d=1, theta=1, Eshift=0, normalized=False):
    temp=np.divide(np.multiply(np.power(E,2),tailedAbsortivityOccCorr(E, Eg, A, T, gam, Dmu, d, theta, Eshift=0.0, normalized=False)),(np.exp(np.divide((E-Dmu),(np.multiply(kb,T))))-1))
    #temp=np.divide(1,np.exp(np.divide((E-Dmu),(np.multiply(k,T))))-1)
    if normalized == False:
        return temp
    elif normalized == True:
        return np.divide(temp,np.amax(temp))

def LSW_tailedAbsAsym_PL (E, Eg, Efe, Ndoping, A, T, gam, d=1, theta=1, Eshift=0, normalized=False):
    dN=exactNfromMuE(Eg, Efe, T, gam)-Ndoping
    Efh=exactMuHfromP(Eg, dN , Temperature, gam)
    Dmu=Efe-Efh
    """
    if Efh<0:       
        Pn=1+np.divide(Efh,(Dmu-Eg))
        Pp=1-Pn
    else:
        Pn=1
        Pp=0
    
    print("LSWasym Ndop  : " + str(Ndoping))
    print("LSWasym dN    : " + str(dN))
    print("LSWasym Eg    : " + str(Eg))
    print("LSWasym Efe   : " + str(Efe))
    print("LSWasym Efh   : " + str(Efh))
    print("LSWasym Dmu   : " + str(Dmu))
    print("LSWasym Pn    : " + str(Pn))
    print("LSWasym Pp    : " + str(Pp))
    """  
    #THis function is shaped such to avoid an overflow in the exponent
    margin=20*kb*T
    temp=np.multiply(np.power(E,2),tailedAbsortivityOccCorrAsym(E, Eg, A, T, gam, Efe, Efh, d=1, theta=1, Eshift=0, normalized=False))
    #lower=np.zeros(int(np.size(E)))
    funcLower = lambda E: (np.exp(np.divide((E-Dmu),(np.multiply(kb,T))))-1)
    n=0
    for i in E:
        if i<Dmu-margin:
            temp[n]=np.divide(temp[n],-1)
            #lower[n]=-1
        elif i>=Dmu-margin and i<=Dmu+margin:
            temp[n]=np.divide(temp[n],funcLower(i))
            #lower[n]=funcLower(i)
        elif i>Dmu+margin:
            temp[n]=0
            #lower[n]=1e10
        else:
            temp[n]=0
            #lower[n]=1e10
            break
        n+=1   
    #temp=np.divide(np.multiply(np.power(E,2),tailedAbsortivityOccCorrAsym(E, Eg, A, T, gam, Efe, Efh, d=1, theta=1, Eshift=0, normalized=False)),(np.exp(np.divide((E-Dmu),(np.multiply(kb,T))))-1))
    if normalized == False:
        return temp
    elif normalized == True:
        return np.divide(temp,np.amax(temp))


def LSW_tailedAbsNoCorr_PL (E, Eg, A, T, gam, Dmu, d=1, theta=1, Eshift=0, normalized=False):
    k=8.61733e-5 #[eV/K]
    temp=np.divide(np.multiply(np.power(E,2),tailedAbsorptivity(E, Eg, A, gam, theta, Eshift=0.0, normalized=False)),(np.exp(np.divide((E-Dmu),(np.multiply(k,T))))-1))
    if normalized == False:
        return temp
    elif normalized == True:
        return np.divide(temp,np.amax(temp[3000:]))

def electronDensity_E(E, Eg, Efe, T, gam, theta=1):  #THis function calculates the number of electrons in the conduction band for any T
    Ac1=np.divide(1,(2*np.power(np.pi,2))) * np.power(np.divide((2*mRestElectron*mEffC1),(np.power((hBar*c),2))),np.divide(3,2))
    return tailedDOS(E, Eg, Ac1, gam, theta)*fermiDirac(E,Efe,T)
    
def holeDensity_E(E, Eg, Efh, T, gam, theta=1):  #THis function calculates the number of electrons in the conduction band for any T
    Av1=np.divide(1,(2*np.power(np.pi,2))) * np.power(np.divide((2*mRestElectron*mEffV1),(np.power((hBar*c),2))),np.divide(3,2))
    return tailedDOS(-E, 0, Av1, gam, theta)*(1-fermiDirac(E,Efh,T))

####################
#About electrons::
####################
def approxNfromMuE(Eg,Efe): #THis function calculates the number of electrons in the conduction band when T=0
    return (np.divide(1,(3*np.power(np.pi,2))))*np.power(np.divide((2*mRestElectron*mEffC1*(Efe-Eg)),(np.power((hBar*c),2))),np.divide(3,2))

def approxMuEfromN(Eg,N): #THis function calculates fermi level in the conduction band for N electrons when T=0
    return np.power(N*3*np.power(np.pi,2),np.divide(2,3))*np.divide(np.power((hBar*c),2),2*mRestElectron*mEffC1)+Eg

def exactNfromMuE(Eg,Efe,T, gam=0):  #THis function calculates the number of electrons in the conduction band for any T
    Elocal = np.arange(0, 2, 0.001)
    return np.trapz(electronDensity_E(Elocal, Eg, Efe, T, gam, theta=1),Elocal)

def exactMuEfromN(Eg, N , T, gam=0):  #THis function NUMERICALLY calculates the fermi level from the number of electrons in the conduction band
    EfeInitial = approxMuEfromN(Eg,N)
    nFromMuE = lambda Efe : exactNfromMuE(Eg,Efe,T, gam=0)-N
    MuE, = fsolve(nFromMuE,EfeInitial)
    return MuE

####################
#About holes::
####################
def approxPfromMuH(Eg,Efh): #THis function calculates the number of holes in the valence band when T=0
    return (np.divide(1,(3*np.power(np.pi,2))))*np.power(np.divide((2*mRestElectron*mEffV1*(-Efh)),(np.power((hBar*c),2))),np.divide(3,2))

def approxMuHfromP(Eg,P): #THis function calculates fermi level in the valence band for P electrons when T=0
    return -np.power(P*3*np.power(np.pi,2),np.divide(2,3))*np.divide(np.power((hBar*c),2),2*mRestElectron*mEffV1)

def exactPfromMuH(Eg, Efh,T, gam=0):  #THis function calculates the number of holes in the valence band for any T
    Elocal = np.arange(np.amin([0,Efh])-500*kb*T, Eg*0.5, 0.001)
    return np.trapz(holeDensity_E(Elocal, Eg, Efh, T, gam, theta=1),Elocal)

def exactMuHfromP(Eg, P , T, gam=0):  #THis function NUMERICALLY calculates the fermi level from the number of electrons in the conduction band
    EfhInitial = approxMuHfromP(Eg,P)
    nFromMuH = lambda Efh : exactPfromMuH(Eg, Efh,T, gam=0)-P
    MuH, = fsolve(nFromMuH,EfhInitial)
    return MuH

def getQuasiFermiLevels(Eg, deltaMu, N, T, gam=0):
    deltaNInitial=5e17
    nFromMuH = lambda dN : deltaMu-(exactMuEfromN(Eg, N+dN , T, gam)-exactMuHfromP(Eg, dN , T, gam))
    deltaN, = fsolve(nFromMuH, deltaNInitial)
    MuE = exactMuEfromN(Eg, N+deltaN , T, gam)
    MuH = exactMuHfromP(Eg, deltaN , T, gam)
    return [MuE, MuH, deltaN]
    

"""
==================================================
===============SET THE VARIABLES==================
==================================================
"""
Ac1=np.divide(1,(2*np.power(np.pi,2))) * np.power(np.divide((2*mRestElectron*mEffC1),(np.power((hBar*c),2))),np.divide(3,2))
Av1=np.divide(1,(2*np.power(np.pi,2))) * np.power(np.divide((2*mRestElectron*mEffV1),(np.power((hBar*c),2))),np.divide(3,2))

#energyData= energyData[startCell:dataLength]
#Normalized280K=Normalized280K[startCell:dataLength]
#Normalized4K=Normalized4K[startCell:dataLength]

#This is a scale I use to get a higher density of data points
energySimu = np.arange(-2, 2, 0.001)
kSimu = np.arange(-10, 10, 0.001)
x_fill=np.zeros(np.size(energySimu),dtype="float")

ymin=-0.5
ymax=1.0






"""
================================================
===========Loop to fit all the data=============
================================================
"""



###############################################################
#Fitting with the Lasher-Stern-Wurfel model
#Temperature dependent
####################################################


#==================Setting fitting parameters
BGEnergy=0.34
Temperature=400
gam=0.01
theta=1
A=45
absorptionLength=1
MuElectron=0.385
nDoping = 2.2e18

FitStartElement=0
FitEndElement=300

#Choose whether to fit the data or simply import it from the previous file
FIT_DATA=True
PRINT_PLOTS=True
EXPORT_RAW_FITS=False
USE_INDIVIDUAL_INIT=False
#============================





#make a new directory of all the output of the PL_V_T data
path = os.getcwd()
print("The current directory is: %s" % path )
newnewfolderpath=path+"/LSWasym_PL_fitting_T-series"
try:
    os.mkdir(newnewfolderpath)
except OSError:
    print('Creation of folder failed')
else:
    print('Succesfully created folder')
try:
    os.chdir(newnewfolderpath)
except OSError:
    print('Failed to change directories to new folder')
else:    
    print('Changed directory to new new folder: ' + newnewfolderpath)

#Check how many things I imported
importSizeTemp=np.size(importedFileTemp[:1])-2

#Make result arrays existing out of zeros
results_LSW_PL = np.zeros(((importSizeTemp),10),dtype=float)


#Make initial values
InVal_LSWasym_PL = [BGEnergy, MuElectron, nDoping, A, Temperature, gam]  # for [amp, cen, wid]

#Energy scale
energyData = importedFileTemp[7:,1]
energyData = energyData.astype(np.float)  #turn into a float data format


#If I do not want the data to be fitted then use the fitted data from a previous session!
if FIT_DATA == False:
     results_LSW_PL=np.array(pd.read_csv("Fitting_results_" + fileNameTemp, sep='\t', header=None))
     results_LSW_PL=results_LSW_PL[2:]
     results_LSW_PL = results_LSW_PL.astype(np.float)
     print(results_LSW_PL)



#Loop to fit with the LSWasym model
for i in range (20, importSizeTemp):
    
    #If the option was chosen to fit the data then all the spectra are fitted if not then the data was imported
    if FIT_DATA==True:
        if USE_INDIVIDUAL_INIT == True:
            init_doubleLSW_PL=np.array(pd.read_csv("InitialValues_" + fileNameTemp, sep='\t', header=1))
            #results_LSW_PL=results_LSW_PL[2:]
            init_doubleLSW_PL = init_doubleLSW_PL.astype(np.float)
            #print(results_LSW_PL)
            #Make initial values doubleLSW
            InVal_doubleLSW_PL = init_doubleLSW_PL[i,2:9]  # for [amp, cen, wid]
               
        #initialize fitting result array
        BestVal_LSWasym_PL = np.zeros(6)
        
        #BestVal_DOS_FD, covar = curve_fit(simpleDOS_FD, energyData, importedFileTemp[7:,i+2], p0=InVal_sDOS_FD)
        data=importedFileTemp[7:,i+2]
        data_original = data.astype(np.float)
        data = np.divide(data_original, np.amax(data_original))
        
        
        #BestVal_LSWasym_PL=InVal_LSWasym_PL
        
        #try: BestVal_LSWasym_PL, covar = curve_fit(LSW_tailedAbsAsym_PL, energyData, data, p0=InVal_LSWasym_PL)
        #except:
        #    print("Something happend!")
        
           
        
        #Fitting with Lambda function
        #Make initial values doubleLSW
        trimmedInVal_LSWasym_PL = [BGEnergy, MuElectron, A, Temperature, gam]  # for [amp, cen, wid]
        trimmedBestVal_LSWasym_PL = np.zeros(5)
        trimmedLSWasym_TailedAbs_PL = lambda fEnergy, fEga, fEfe, fA, fT, fgam: LSW_tailedAbsAsym_PL(fEnergy, fEga, fEfe, nDoping, fA, fT, fgam)
        try: 
            trimmedBestVal_LSWasym_PL, covar = curve_fit(trimmedLSWasym_TailedAbs_PL, energyData[FitStartElement:FitEndElement], data[FitStartElement:FitEndElement], p0=trimmedInVal_LSWasym_PL)
            print("I tried!!")
            print(str(trimmedBestVal_LSWasym_PL))
        except:
            print("Something happend!")
        BestVal_LSWasym_PL[0]=trimmedBestVal_LSWasym_PL[0]
        BestVal_LSWasym_PL[1]=trimmedBestVal_LSWasym_PL[1]
        BestVal_LSWasym_PL[2]=nDoping
        BestVal_LSWasym_PL[3]=trimmedBestVal_LSWasym_PL[2]
        BestVal_LSWasym_PL[4]=trimmedBestVal_LSWasym_PL[3]
        BestVal_LSWasym_PL[5]=trimmedBestVal_LSWasym_PL[4]
        #[BGEnergy, MuElectron, nDoping, A, Temperature, gam]      
        
        
        #Save the temperature of the spectrum to the fit and the fitting results
        results_LSW_PL[i,1:7]=BestVal_LSWasym_PL
        results_LSW_PL[i,0]=importedFileTemp[3,i+2]   
        #Do some after processing to get aditional values:
        #calculate the fitted spectrum
        calculated_LSWasym_PL = LSW_tailedAbsAsym_PL(energyData, BestVal_LSWasym_PL[0], BestVal_LSWasym_PL[1], BestVal_LSWasym_PL[2], BestVal_LSWasym_PL[3], BestVal_LSWasym_PL[4], BestVal_LSWasym_PL[5])
        calculated_LSWasym_PL_normalized = LSW_tailedAbsAsym_PL(energyData, BestVal_LSWasym_PL[0], BestVal_LSWasym_PL[1], BestVal_LSWasym_PL[2], BestVal_LSWasym_PL[3], BestVal_LSWasym_PL[4], BestVal_LSWasym_PL[5], normalized=True)
        #Determine at which energy the maximum occurs
        results_LSW_PL[i,7]=energyData[np.argmax(calculated_LSWasym_PL)]
        #Determine the intensity by integrating the fitted graph and multiplying with the height
        results_LSW_PL[i,8]=np.multiply(np.multiply(np.trapz(calculated_LSWasym_PL, energyData),np.amax(data_original)),np.amax(calculated_LSWasym_PL))
        #Also determine the intensity by integrating the original
        results_LSW_PL[i,9]=np.trapz(data_original, energyData)
        
        
    #If I did not fit I have to initialize some parameters    
    else:
        #This line is just to make sure that BestVal_biGauss_PL has the right value when imported
        BestVal_LSWasym_PL=results_LSW_PL[i,1:6]
        #This line is to get the right data selected when the fitting parameters are imported
        data=importedFileTemp[7:,i+2]
        data_original = data.astype(np.float)
        data=np.divide(data_original,np.amax(data_original))
        #calculate the fitted spectrum
        calculated_LSWasym_PL = LSW_tailedAbsAsym_PL(energyData, BestVal_LSWasym_PL[0], BestVal_LSWasym_PL[1], BestVal_LSWasym_PL[2], BestVal_LSWasym_PL[3], BestVal_LSWasym_PL[4], BestVal_LSWasym_PL[5])
        calculated_LSWasym_PL_normalized = LSW_tailedAbsAsym_PL(energyData, BestVal_LSWasym_PL[0], BestVal_LSWasym_PL[1], BestVal_LSWasym_PL[2], BestVal_LSWasym_PL[3], BestVal_LSWasym_PL[4], BestVal_LSWasym_PL[5], normalized=True)
    
    fEg=BestVal_LSWasym_PL[0]
    fT=BestVal_LSWasym_PL[4]
    fGam=BestVal_LSWasym_PL[5]
    fA=BestVal_LSWasym_PL[3]
    fEfe=BestVal_LSWasym_PL[1]
    fnDop = BestVal_LSWasym_PL[2]
    fdN=exactNfromMuE(fEg, fEfe, fT, fGam)-fnDop 
    fEfh=exactMuHfromP(fEg, fdN , fT, fGam)
    fDmu=fEfe-fEfh
    if fEfh<0:       
        fPn=1+np.divide(fEfh,(fDmu-fEg))
        fPp=1-fPn
    else:
        Pn=1
        Pp=0 
    fDmu=fEfe-fEfh
       
    
    print("Finished with temperature: " + str(importedFileTemp[3,i+2]))
    print("LSWasym Eg      : " + str(fEg))
    print("LSWasym Efe     : " + str(fEfe))
    print("LSWasym Efh     : " + str(fEfh))
    print("LSWasym DeltaMu : " + str(fDmu))
    print("LSWasym Pn      : " + str(fPn))
    print("LSWasym Pp      : " + str(fPp))
    print("LSWasym Ndoping : " + str(fnDop))
    print("LSWasym dN      : " + str(fdN))
    print("LSWasym A       : " + str(fA))
    print("LSWasym T       : " + str(fT))
    print("LSWasym gamma   : " + str(fGam))
    
    
    if PRINT_PLOTS==True:
        plt.figure(figsize=(15, 5))
        plt.subplot(1, 3, 1)
        plt.plot(energyData, data, 'r')
        plt.plot(energyData, calculated_LSWasym_PL , 'b--')
        plt.plot(energyData, LSW_tailedAbsAsym_PL(energyData, InVal_LSWasym_PL[0], InVal_LSWasym_PL[1],InVal_LSWasym_PL[2],InVal_LSWasym_PL[3],InVal_LSWasym_PL[4],InVal_LSWasym_PL[5]), 'g--')
        plt.text(0.26, 1.15, "T= " + str(importedFileTemp[3,i+2]) + "K", horizontalalignment='left', verticalalignment='top', fontsize=18)
        plt.axvline(x=BestVal_LSWasym_PL[0],linewidth=1.0, dashes=(5,5))
        plt.axis([0.2, 0.60, 0.0, 1.2])
        plt.subplot(1, 3, 2)
        plt.semilogy(energyData, data, 'r')
        plt.semilogy(energyData, calculated_LSWasym_PL, 'b--')
        plt.axvline(x=BestVal_LSWasym_PL[0],linewidth=1.0, dashes=(5,5))
        plt.axis([0.2, 0.60, 0.001, 1.2])
        plt.subplot(1, 3, 3)
        #plt.semilogy(energySimu,tailedAbsortivityOccCorr(energySimu, BestVal_LSW_PL[0], BestVal_LSW_PL[1], BestVal_LSW_PL[2], BestVal_LSW_PL[3], BestVal_LSW_PL[4], d=1, theta=1, Eshift=0, normalized=True), label='Absty_OcCor')
        #plt.semilogy(energySimu,tailedAbsorptivity (energySimu, BestVal_LSW_PL[0],BestVal_LSW_PL[1], BestVal_LSW_PL[3], theta=1, Eshift=0, d=1, normalized=True), label='TailedAbsty')
        #plt.semilogy(energySimu,simpleAbsorptivity (energySimu, BestVal_LSW_PL[0],BestVal_LSW_PL[1], normalized=True), label='SimpleAbsty')
        plt.legend(loc='left')
        plt.axis([0.25, 0.41, 0.01, 1.1])
        #Line indicating the bandgap
        plt.axvline(x=BestVal_LSWasym_PL[0],linewidth=2.0, dashes=(5,5), color='g')
        #line indicating the fermisplitting
        plt.axvline(x=BestVal_LSWasym_PL[4],linewidth=2.0, dashes=(5,5), color='r')
        #save the figure in the current directory
        plt.savefig('LSW_PL_'+ str(importedFileTemp[3,i+2]) + 'K.png')
        plt.show()
        
        
    break


#create a .txt file with the same name as the h5 file and save in the same location
Header='\r\n'.join(["Temperature\tBandgap\tScalingFactor\tPLTemperature\tGamma\tDeltaMu\tPeakCenter\tIntensity\ttrapz Intensity", "K\teV\t-\tK\teV\teV\teV\ta.u.\ta.u."])
np.savetxt("Fitting_results_" + fileNameTemp, results_LSW_PL, fmt='%.5e', delimiter='\t', header=Header, newline='\r\n', comments='')



if EXPORT_RAW_FITS:
    #Check how long the energy axis will be
    number_of_simu_datapoints=np.size(energySimu)
    #Then check how many fits there have been made and initialize an array for the output.
    Fit_plot_data=np.zeros((number_of_simu_datapoints+1, importSizeTemp+1), dtype=float)
    #set the first column with the energy data and the first row with the powers
    Fit_plot_data[1:,0]=energySimu
    Fit_plot_data[0,1:]=results_LSW_PL[:,0]
    #now calculate the output spectrum for all the fitted spectra and save in the output array
    for i in range(importSizeTemp):
        Fit_plot_data[1:,i+1]=LSW_tailedAbs_PL(energySimu, results_LSW_PL[i,1], results_LSW_PL[i,2], results_LSW_PL[i,3], results_LSW_PL[i,4], results_LSW_PL[i,5]) 
    np.savetxt("Fitting_rawdata_" + fileNameTemp, Fit_plot_data, fmt='%.5e', delimiter='\t', newline='\r\n', comments='')


"""
#Output the results
print(Header)
print(results_LSW_PL)

plt.figure(2, figsize=(6, 16), dpi=80, facecolor='w', edgecolor='k')



for i in range (0, importSizeTemp):
    data=importedFileTemp[7:,i+2]
    data = data.astype(np.float)
    data = np.divide(data, np.amax(data))
    plt.plot(energyData, data+0.5*i, 'r')
    plt.plot(energyData, LSW_tailedAbs_PL(energyData, results_LSW_PL[i,1], results_LSW_PL[i,2], results_LSW_PL[i,3], results_LSW_PL[i,4], results_LSW_PL[i,5], normalized=True)+0.5*i, 'b--')
    plt.text(0.59, 0.1+0.5*i, "T= " + str(importedFileTemp[3,i+2]) + "K", horizontalalignment='right', verticalalignment='bottom', fontsize=12)
plt.axis([0.2, 0.60, 0, 17])
#save the figure in the current directory
plt.savefig('PL_LSW_PL_T-Stack.png')
plt.show
os.chdir(path)


#This is just a temorary check
plt.figure(3, figsize=(18, 6))
plt.subplot(1,3,1)
plt.plot(results_LSW_PL[:,0],results_LSW_PL[:,1], "bh", label="Bandgap" )
plt.plot(results_LSW_PL[:,0],results_LSW_PL[:,5], "r.", label="DeltaMu" )
plt.plot(results_LSW_PL[:,0],results_LSW_PL[:,6], "gv",label="Peak" )
plt.xlabel('Temperature (K)')
plt.ylabel('Energy (eV)')
plt.legend(loc="best")
plt.subplot(1,3,2)
plt.semilogy(results_LSW_PL[:,0],results_LSW_PL[:,7], "bh", label="Fitted Intensity" )
plt.semilogy(results_LSW_PL[:,0],results_LSW_PL[:,8], "r.", label="Raw Intensity" )
plt.xlabel('Temperature (K)')
plt.ylabel('Intensity (a.u.)')
plt.legend(loc="best")
plt.subplot(1,3,3)
plt.plot(results_LSW_PL[:,0],results_LSW_PL[:,3], "r.", label="Electron temperature" )
plt.plot(results_LSW_PL[:,0],results_LSW_PL[:,0], label="Lattice temperature" )
plt.xlabel('lattice Temperature (K)')
plt.ylabel('Temperature(K)')
plt.legend(loc="best")
plt.savefig('PL_LSW_BG_DMu.png')
plt.show()

plt.figure(4, figsize=(18,6))
plt.subplot(1,3,1)
plt.plot(results_LSW_PL[:,0],results_LSW_PL[:,5]-results_LSW_PL[:,1], "bh", label="DeltaMu-BG" )
plt.xlabel('Temperature (K)')
plt.ylabel('DeltaMu-BG (eV)')
plt.legend(loc="best")
plt.subplot(1,3,2)
plt.plot(results_LSW_PL[:,0],results_LSW_PL[:,4], "bh", label="Gamma" )
plt.xlabel('Temperature (K)')
plt.ylabel('Gamma (eV)')
plt.legend(loc="best")
plt.subplot(1,3,3)
plt.plot(results_LSW_PL[:,0],results_LSW_PL[:,2], "bh", label="Scaling constant" )
plt.xlabel('Temperature (K)')
plt.ylabel('Scaling constant')
plt.legend(loc="best")
plt.savefig('PL_Gamma_Scaling.png')
plt.savefig('PL_LSW_BGDmu_Gamma_scaling.png')
plt.show()
"""